<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CustomizedTrips extends Model 
{

    protected $table = 'customized_trips';
    public $timestamps = true;
    protected $fillable = array('client_id', 'type', 'category_id', 'date_start', 'date_end', 'start_time', 'end_time', 'description', 'duration', 'country_id', 'city_id', 'male_count', 'female_count', 'children_count', 'offer_id', 'guide_id', 'status');

    public function offers()
    {
        return $this->hasMany('Offer', 'trip_id');
    }

    public function client()
    {
        return $this->belongsTo('User', 'client_id');
    }

    public function guide()
    {
        return $this->belongsTo('User', 'guide_id');
    }

}